import { StyleSheet, Dimensions } from "react-native";
import dpr from "../../Utilities/CustomStyleAttribute/dpr";
const { width } = Dimensions.get("screen");

const categoriesStyle = StyleSheet.create({
    container: {},
    title: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(18),
        color: "#000000",
        lineHeight: dpr(26),
        marginTop: dpr(30),
        marginBottom: dpr(15),
    },
    item: {
        borderWidth: 1,
        flexDirection: "column",
        justifyContent: "center",
        alignItems: "center",
        borderRadius: 5,
        borderColor: "#DFDFDF",
        paddingHorizontal: dpr(8),
    },
    categoryItemNameCont: (length, index) => ({
        height: dpr(130),
        width: dpr(130),
        marginRight: length == index ? 0 : dpr(15),
    }),
    img: {
        marginTop: dpr(10),
        marginBottom: dpr(10),
        borderRadius: 5,
        height: dpr(45),
        width: dpr(50)
    },
    text: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(11),
        color: "#898989",
        textAlign: "center",
        marginTop: dpr(6),
        lineHeight: dpr(16),
    },
    emptyTextStyle: {
        textAlign: "center",
        width: width,
        marginVertical: 10,
        color: "#A3A3A5",
    },
});

export { categoriesStyle };
